using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml;
using System.Xml.Schema;


namespace Transform
{
    public partial class frmEDISmapSegment : Form
    {
        XmlSchema myXmlSchema;
        string XSDpath;
        clsSchemaModel schemaModel;

        public frmEDISmapSegment(XmlSchema myXmlSchema, string XSDpath, clsSchemaModel schemaModel)
        {
            this.myXmlSchema = myXmlSchema;
            this.XSDpath = XSDpath;
            this.schemaModel = schemaModel;
            InitializeComponent();
        }

        public void fillForm() 
        {
            cmbDataType.Text = schemaModel.dataType;
            txtCharacters.Text = "" + schemaModel.characters;
            txtCode.Text = schemaModel.code;
            txtDescription.Text = schemaModel.description;
            txtFormat.Text = schemaModel.format;
            txtHeading.Text = schemaModel.heading;
            txtRepeats.Text = "" + schemaModel.repeats;
            txtValue.Text = schemaModel.value;
            if (schemaModel.mandatory)
                chkMandatory.Checked = true;
            else
                chkMandatory.Checked = false;
        }

        private void btnSubmit_Click(object sender, EventArgs e)
        {
            bool error = updateXSDfile();
            if (!error)
                this.Close();
            else
            {
                fillSchemaModel();
                updateXSDfile();
            }
        }

        private void fillSchemaModel()
        {
            txtCharacters.Text = "" + schemaModel.characters;
            txtCode.Text = schemaModel.code;
            cmbDataType.Text = schemaModel.dataType;
            txtDescription.Text = schemaModel.description;
            txtFormat.Text = schemaModel.format;
            txtHeading.Text = schemaModel.heading;
            if (schemaModel.mandatory)
                chkMandatory.Checked = true;
            else
                chkMandatory.Checked = false;
            txtRepeats.Text = "" + schemaModel.repeats;
            txtValue.Text = schemaModel.value;
        }

        private bool updateXSDfile() 
        {
            clsXSDtool xsdTool = new clsXSDtool(myXmlSchema, XSDpath, this);
            bool error = xsdTool.WriteXSDSchema();
            return error;
        }

    }
}